<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::table('settings', function (Blueprint $table) {
            $table->boolean('auto_backup_enabled')->default(false)->after('idle_time_minutes');
            $table->time('auto_backup_time')->nullable()->after('auto_backup_enabled');
            $table->string('backup_path')->nullable()->after('auto_backup_time');
        });
    }

    public function down(): void
    {
        Schema::table('settings', function (Blueprint $table) {
            $table->dropColumn(['auto_backup_enabled', 'auto_backup_time', 'backup_path']);
        });
    }
};
