<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('settings', function (Blueprint $table) {
            $table->id();
            $table->string('company_name')->nullable();
            $table->text('company_address')->nullable();
            $table->string('company_phone')->nullable();
            $table->string('company_contact')->nullable();
            $table->string('company_logo')->nullable();
            $table->string('currency_local_name')->default('Peso');
            $table->string('currency_local_symbol')->default('$');
            $table->string('currency_usd_name')->default('Dólar');
            $table->string('currency_usd_symbol')->default('$');
            $table->decimal('exchange_rate', 10, 2)->default(1);
            $table->integer('idle_time_minutes')->default(5);
            $table->timestamps();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('settings');
    }
};
