# DA-Invent

Sistema de gestión de inventario y punto de venta construido con Laravel.

## Características

- **Gestión de usuarios y roles**: Sistema de autenticación con Laravel Sanctum y roles (admin, vendedor, almacén)
- **Catálogo de productos**: CRUD de productos con categorías
- **Inventario**: Control de stock con ajustes de inventario
- **Compras**: Registro de compras a proveedores
- **Ventas**: Punto de venta con gestión de clientes
- **Facturación**: Sistema de emisión de facturas
- **Dashboard**: Estadísticas, gráficos de ventas/compras y alertas de stock bajo

## Tecnologías

- Laravel 11
- Laravel Sanctum (API Authentication)
- MySQL

## Instalación

```bash
composer install
cp .env.example .env
php artisan key:generate
php artisan migrate
php artisan db:seed
php artisan serve
```

## API Endpoints

### Autenticación
- `POST /api/auth/register` - Registrar usuario
- `POST /api/auth/login` - Iniciar sesión
- `POST /api/auth/logout` - Cerrar sesión
- `GET /api/auth/me` - Datos del usuario actual

### Recursos
- `/api/roles` - Roles de usuario
- `/api/users` - Usuarios
- `/api/categories` - Categorías
- `/api/suppliers` - Proveedores
- `/api/products` - Productos
- `/api/purchases` - Compras
- `/api/sales` - Ventas
- `/api/invoices` - Facturas
- `/api/customers` - Clientes
- `/api/inventories` - Inventario
- `/api/dashboard` - Dashboard y estadísticas

## Licencia

MIT
